<?php

namespace Tests\Feature;

use App\Models\User;
use App\Models\Company;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Notification;
use Illuminate\Auth\Notifications\VerifyEmail;
use Tests\TestCase;

class CompanyCreationTest extends TestCase
{
    use RefreshDatabase;

    public function test_employee_can_create_company_and_client_user_and_email_sent()
    {
        Notification::fake();

        $employee = User::factory()->create(['role' => 'employee']);
        $this->actingAs($employee);

        $payload = [
            'name' => 'Empresa Teste',
            'identifier' => 'EMP123',
            'user_name' => 'Cliente Teste',
            'user_email' => 'cliente@example.com',
            'user_password' => 'secret123',
            'user_password_confirmation' => 'secret123',
        ];

        $res = $this->post(route('companies.store'), $payload);

        $res->assertRedirect();

        $this->assertDatabaseHas('users', ['email' => 'cliente@example.com', 'role' => 'client']);
        $this->assertDatabaseHas('companies', ['name' => 'Empresa Teste']);

    $user = User::where('email', 'cliente@example.com')->first();
    Notification::assertNotSentTo($user, VerifyEmail::class);
    }
}
