<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class AdminUserManagementTest extends TestCase
{
    use RefreshDatabase;

    public function test_superadmin_can_create_edit_and_delete_user()
    {
        $admin = User::factory()->create(['role' => 'superadmin']);

        $this->actingAs($admin)
            ->post('/admin/users', [
                'name' => 'Employee One',
                'email' => 'emp1@example.com',
                'password' => 'secret123',
                'role' => 'employee',
            ])
            ->assertRedirect();

        $this->assertDatabaseHas('users', ['email' => 'emp1@example.com']);

        $user = User::where('email', 'emp1@example.com')->first();

        $this->actingAs($admin)
            ->patch('/admin/users/'.$user->id, [
                'name' => 'Employee One Updated',
                'email' => 'emp1@example.com',
                'role' => 'employee'
            ])
            ->assertRedirect();

        $this->assertDatabaseHas('users', ['email' => 'emp1@example.com', 'name' => 'Employee One Updated']);

        $this->actingAs($admin)
            ->delete('/admin/users/'.$user->id)
            ->assertRedirect();

        $this->assertDatabaseMissing('users', ['email' => 'emp1@example.com']);
    }
}
