<?php
    $user = \Illuminate\Support\Facades\Auth::user();
    $layout = 'layouts.app';
    if ($user) {
        if ($user->role === 'client') $layout = 'layouts.client';
        elseif ($user->role === 'employee') $layout = 'layouts.employee';
        elseif ($user->role === 'superadmin') $layout = 'layouts.admin';
    }
?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Ocorrências: <?php echo e($occType->name); ?></h1>
        <?php
            $slug = \Illuminate\Support\Str::ascii(\Illuminate\Support\Str::slug($occType->name));
        ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', \App\Models\Occurrence::class)): ?>
            <?php if(in_array($slug, ['chamadas','emails','recepcao'])): ?>
                <a href="<?php echo e(route('occurrences.' . $slug . '.create')); ?>" class="btn btn-success">Registrar <?php echo e($occType->name); ?></a>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <?php if($occurrences->isEmpty()): ?>
        <div class="alert alert-info">Não há ocorrências deste tipo.</div>
    <?php else: ?>
        <div class="row">
            <?php $__currentLoopData = $occurrences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $occ): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 mb-3">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo e($occ->title ?? ('Ocorrência #' . $occ->id)); ?></h5>
                            <p class="card-text"><?php echo e(\Illuminate\Support\Str::limit($occ->details ?? $occ->description ?? '-', 200)); ?></p>
                            <p class="mb-1"><small class="text-muted">Empresa: <?php echo e($occ->company->name ?? '—'); ?></small></p>
                            <p class="mb-2"><small class="text-muted">Criado: <?php echo e($occ->created_at->format('d/m/Y H:i')); ?> por <?php echo e(optional($occ->user)->name ?? 'Sistema'); ?></small></p>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $occ)): ?>
                                <a href="<?php echo e(route('occurrences.show', $occ)); ?>" class="btn btn-outline-primary btn-sm">Ver</a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $occ)): ?>
                                <?php if(Route::has('occurrences.edit')): ?>
                                    <a href="<?php echo e(route('occurrences.edit', $occ)); ?>" class="btn btn-outline-secondary btn-sm">Editar</a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="mt-3"><?php echo e($occurrences->links()); ?></div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\virtuals\resources\views/occurrences/type.blade.php ENDPATH**/ ?>