<nav class="navbar navbar-expand-lg navbar-light bg-light">
  <div class="container-fluid">
    <a class="navbar-brand" href="<?php echo e(route('dashboard')); ?>"><?php echo e(config('app.name', 'Virtual Office')); ?></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
        </li>
        <?php if(auth()->guard()->check()): ?>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(route('company.indexPanel')); ?>">Empresas</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(route('attachments.index')); ?>">Anexos</a>
        </li>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="occTypesMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">Ocorrências</a>
          <ul class="dropdown-menu" aria-labelledby="occTypesMenu">
            <li><a class="dropdown-item" href="<?php echo e(route('occurrences.chamadas')); ?>">Chamadas</a></li>
            <li><a class="dropdown-item" href="<?php echo e(route('occurrences.emails')); ?>">Emails</a></li>
            <li><a class="dropdown-item" href="<?php echo e(route('occurrences.recepcao')); ?>">Recepção</a></li>
          </ul>
        </li>
        <?php if(in_array(Auth::user()->role, ['employee','superadmin'])): ?>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(route('employee.companies')); ?>">Área Funcionário</a>
        </li>
        <?php endif; ?>
        <?php endif; ?>
      </ul>

      <ul class="navbar-nav ms-auto">
        <?php if(auth()->guard()->check()): ?>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="userMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <?php echo e(Auth::user()->name); ?>

          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userMenu">
            <li><a class="dropdown-item" href="<?php echo e(route('profile.edit')); ?>">Perfil</a></li>
            <li>
              <form method="POST" action="<?php echo e(route('logout')); ?>"><?php echo csrf_field(); ?>
                <button class="dropdown-item" type="submit">Sair</button>
              </form>
            </li>
          </ul>
        </li>
    <?php else: ?>
    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('login')); ?>">Login</a></li>
    <?php if(Route::has('register')): ?>
      <li class="nav-item"><a class="nav-link" href="<?php echo e(route('register')); ?>">Registrar</a></li>
    <?php endif; ?>
    <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
<?php /**PATH C:\laragon\www\virtuals\resources\views/layouts/navigation.blade.php ENDPATH**/ ?>