<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Bootstrap CSS (CDN) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-..." crossorigin="anonymous">

    <!-- Optional Google font -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">

    <!-- Optional app styles -->
    <style>body{font-family:Inter,ui-sans-serif,system-ui,-apple-system,'Segoe UI',Roboto,'Helvetica Neue',Arial}</style>
    
    <?php echo $__env->yieldPushContent('head'); ?>
    </head>
    <body>
        <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="container mt-4">
            <?php if (! empty(trim($__env->yieldContent('header')))): ?>
                <div class="pb-3 mb-3 border-bottom">
                    <?php echo $__env->yieldContent('header'); ?>
                </div>
            <?php endif; ?>

            <main>
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>

        <!-- jQuery (required by Select2) -->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJ+Y3Jv6v7g8m6k5y5s6b2eQ5+Z5P6X9i1h4=" crossorigin="anonymous"></script>
        <!-- Select2 CSS & JS (CDN) -->
        <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

        <!-- Bootstrap JS (CDN) -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-..." crossorigin="anonymous"></script>

        <script>
            $(document).ready(function(){
                $('.select2').each(function(){
                    var $el = $(this);
                    var ajax = $el.data('ajax');
                    if (ajax) {
                        $el.select2({
                            width: '100%',
                            placeholder: $el.data('placeholder') || 'Pesquisar...',
                            allowClear: true,
                            ajax: {
                                url: ajax,
                                dataType: 'json',
                                delay: 250,
                                data: function(params){
                                    return { q: params.term, page: params.page || 1 };
                                },
                                processResults: function(data, params){
                                    params.page = params.page || 1;
                                    return {
                                        results: data.results,
                                        pagination: { more: data.pagination.more }
                                    };
                                },
                                cache: true
                            }
                        });
                    } else {
                        $el.select2({ width: '100%', placeholder: $el.data('placeholder') || 'Escolha uma opção', allowClear: true });
                    }
                });
            });
        </script>
        <?php echo $__env->make('partials.toasts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </body>
</html>
<?php /**PATH C:\laragon\www\virtuals\resources\views/layouts/app.blade.php ENDPATH**/ ?>