<section>
    <header>
        <h5><?php echo e(__('Profile Information')); ?></h5>
        <p class="small text-muted"><?php echo e(__("Update your account's profile information and email address.")); ?></p>
    </header>

    <form id="send-verification" method="post" action="<?php echo e(route('verification.send')); ?>"><?php echo csrf_field(); ?></form>

    <form method="post" action="<?php echo e(route('profile.update')); ?>" class="mt-3">
        <?php echo csrf_field(); ?>
        <?php echo method_field('patch'); ?>

        <div class="mb-3">
            <label for="name" class="form-label"><?php echo e(__('Name')); ?></label>
            <input id="name" name="name" type="text" class="form-control" value="<?php echo e(old('name', $user->name)); ?>" required autofocus>
            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="mb-3">
            <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
            <input id="email" name="email" type="email" class="form-control" value="<?php echo e(old('email', $user->email)); ?>" required>
            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

            <?php if($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail()): ?>
                <div class="mt-2">
                    <p class="small text-muted"><?php echo e(__('Your email address is unverified.')); ?>

                        <button form="send-verification" class="btn btn-link p-0"><?php echo e(__('Click here to re-send the verification email.')); ?></button>
                    </p>

                    <?php if(session('status') === 'verification-link-sent'): ?>
                        <p class="mt-2 text-success small"><?php echo e(__('A new verification link has been sent to your email address.')); ?></p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="d-flex gap-2">
            <button class="btn btn-primary"><?php echo e(__('Save')); ?></button>

            <?php if(session('status') === 'profile-updated'): ?>
                <div class="small text-muted"><?php echo e(__('Saved.')); ?></div>
            <?php endif; ?>
        </div>
    </form>
</section>
<?php /**PATH C:\laragon\www\virtuals\resources\views/profile/partials/update-profile-information-form.blade.php ENDPATH**/ ?>