

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card my-4">
            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-dark shadow-dark border-radius-lg pt-4 pb-3">
                    <h6 class="text-white text-capitalize ps-3"><?php echo e($occType->name ?? 'Ocorrências'); ?></h6>
                </div>
            </div>
            <div class="card-body px-0 pb-2">
                <div class="p-3 d-flex justify-content-end">
                    
                    <?php if(isset($company)): ?>
                        <a href="<?php echo e(route('employee.companies.occurrences.create', $company->id)); ?>" class="btn btn-success">Criar Ocorrência</a>
                    <?php else: ?>
                        <?php $slug = \Illuminate\Support\Str::ascii(\Illuminate\Support\Str::slug($occType->name, '')); ?>
                        <?php if(in_array($slug, ['chamadas','emails','recepcao'])): ?>
                            <a href="<?php echo e(route('occurrences.' . $slug . '.create')); ?>" class="btn btn-success">Criar Ocorrência</a>
                        <?php else: ?>
                            <a href="<?php echo e(route('occurrences.chamadas.create')); ?>" class="btn btn-success">Criar Ocorrência</a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                            <tr>
                                <th>Título</th>
                                <th>Registro</th>
                                <th class="text-center">Empresa</th>
                                <th class="text-center">Anexos</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $occurrences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $occ): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="d-flex px-2 py-1">
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm"><?php echo e(Str::limit($occ->title ?? $occ->description ?? '', 30)); ?></h6>
                                                <p class="text-xs text-secondary mb-0"><?php echo e(Str::limit($occ->description, 80)); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="text-secondary text-xs"><?php echo e($occ->created_at->format('d/m/Y H:i')); ?></span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs"><?php echo e($occ->company->name ?? '-'); ?></span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs"><?php echo e($occ->attachments->count()); ?></span>
                                    </td>
                                    <td class="align-middle text-end">
                                        <a href="<?php echo e(route('occurrences.show', $occ->id)); ?>" class="btn btn-sm btn-primary">Ver</a>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $occ)): ?>
                                            <a href="<?php echo e(route('occurrences.edit', $occ->id)); ?>" class="btn btn-sm btn-secondary">Editar</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-secondary">Nenhuma ocorrência encontrada.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="p-3"><?php echo e($occurrences->links()); ?></div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\virtuals\resources\views/employee/occurrences.blade.php ENDPATH**/ ?>