<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', 'App')); ?> - Recuperar password</title>

    <!-- Fonts & icons -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <link href="/assets/css/nucleo-icons.css" rel="stylesheet" />
    <link href="/assets/css/nucleo-svg.css" rel="stylesheet" />

    <!-- Material Dashboard CSS -->
    <link id="pagestyle" href="/assets/css/material-dashboard.min.css" rel="stylesheet" />

    <style>
        body { font-family: Inter, system-ui, -apple-system, 'Segoe UI', Roboto, 'Helvetica Neue', Arial; background: #0f172a; }
        .login-hero { min-height: 100vh; display: flex; align-items: center; justify-content: center; background: linear-gradient(180deg,#0b1220 0%, rgba(11,18,32,0.6) 60%), url('/assets/img/login-bg.jpg'); background-size: cover; background-position: center; }
        .card-sign { border-radius: 12px; box-shadow: 0 10px 30px rgba(2,6,23,0.6); overflow: hidden; }
        .brand { display:flex; align-items:center; gap:.5rem; }
        .brand img { height:36px }
        .footer-small { font-size:.85rem; color: rgba(255,255,255,0.6) }

        /* colored borders always visible (blue) */
        .card-sign .form-control { border: 1.5px solid rgba(13,71,161,0.28); transition: box-shadow .18s ease, border-color .18s ease, transform .12s ease; border-radius: 8px; padding: .9rem 1rem; background: #fff; }
        .card-sign .form-control:hover { border-color: rgba(13,71,161,0.42); box-shadow: 0 6px 18px rgba(13,71,161,0.06); }
        /* focus: green with stronger shadow */
        .card-sign .form-control:focus { outline: none; border-color: #16a34a; box-shadow: 0 18px 40px rgba(16,163,74,0.18), 0 0 0 10px rgba(16,163,74,0.05); transform: translateY(-2px); }
        /* invalid state (only when server marks the field with .is-invalid) */
        .card-sign .form-control.is-invalid { border-color: #e11d48; box-shadow: 0 6px 18px rgba(225,29,72,0.06); }
        /* Override browser default :invalid styling */
        .card-sign .form-control:invalid { border-color: rgba(13,71,161,0.28); box-shadow: none; }
        .card-sign .form-control:required:invalid { border-color: rgba(13,71,161,0.28); box-shadow: none; }

        .card-sign .form-label { display: block; margin-bottom: .5rem; color: #374151; transition: color .14s ease, transform .14s ease; }
        .card-sign .btn-primary { background: linear-gradient(90deg,#206bc4,#1866b3); border: none; box-shadow: 0 8px 20px rgba(24,102,179,0.18); transition: transform .12s ease, box-shadow .12s ease; }
        .card-sign .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 14px 30px rgba(24,102,179,0.22); }
    </style>
</head>
<body>
    <div class="login-hero">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-8 col-12">
                    <div class="card card-sign bg-white card-sign p-0">
                        <div class="row g-0">
                            <div class="col-12">
                                <div class="p-4">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div class="brand">
                                            <img src="/assets/img/favicon.png" alt="logo">
                                            <div>
                                                <div class="h6 mb-0"><?php echo e(config('app.name', 'Aplicação')); ?></div>
                                                <small class="text-muted">Recuperar password</small>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if(session('status')): ?>
                                        <div class="alert alert-info"><?php echo e(session('status')); ?></div>
                                    <?php endif; ?>

                                    <form method="POST" action="<?php echo e(route('password.email')); ?>">
                                        <?php echo csrf_field(); ?>

                                        <div class="form-group mb-3">
                                            <label class="form-label">Email</label>
                                            <input id="email" name="email" type="email" class="form-control form-control-lg" value="<?php echo e(old('email')); ?>" required autofocus>
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger small"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="d-grid mb-3">
                                            <button type="submit" class="btn btn-primary btn-lg">Enviar link de recuperação</button>
                                        </div>

                                        <div class="text-center mb-0">
                                            <small class="footer-small"><a href="<?php echo e(route('login')); ?>">Voltar para o login</a></small>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-center py-3 bg-light">
                            <small class="text-muted">© <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. Todos os direitos reservados.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Core JS Files -->
    <script src="/assets/js/core/popper.min.js"></script>
    <script src="/assets/js/core/bootstrap.min.js"></script>
    <script src="/assets/js/material-dashboard.min.js"></script>
</body>
</html>
<?php /**PATH C:\laragon\www\virtuals\resources\views/auth/forgot-password.blade.php ENDPATH**/ ?>