@php
    $user = \Illuminate\Support\Facades\Auth::user();
    $layout = 'layouts.app';
    if ($user) {
        if ($user->role === 'client') $layout = 'layouts.client';
        elseif ($user->role === 'employee') $layout = 'layouts.employee';
        elseif ($user->role === 'superadmin') $layout = 'layouts.admin';
    }
@endphp

@extends($layout)

@section('content')
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Ocorrências: {{ $occType->name }}</h1>
        @php
            $slug = \Illuminate\Support\Str::ascii(\Illuminate\Support\Str::slug($occType->name));
        @endphp
        @can('create', \App\Models\Occurrence::class)
            @if(in_array($slug, ['chamadas','emails','recepcao']))
                <a href="{{ route('occurrences.' . $slug . '.create') }}" class="btn btn-success">Registrar {{ $occType->name }}</a>
            @endif
        @endcan
    </div>

    @if($occurrences->isEmpty())
        <div class="alert alert-info">Não há ocorrências deste tipo.</div>
    @else
        <div class="row">
            @foreach($occurrences as $occ)
                <div class="col-md-6 mb-3">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title">{{ $occ->title ?? ('Ocorrência #' . $occ->id) }}</h5>
                            <p class="card-text">{{ \Illuminate\Support\Str::limit($occ->details ?? $occ->description ?? '-', 200) }}</p>
                            <p class="mb-1"><small class="text-muted">Empresa: {{ $occ->company->name ?? '—' }}</small></p>
                            <p class="mb-2"><small class="text-muted">Criado: {{ $occ->created_at->format('d/m/Y H:i') }} por {{ optional($occ->user)->name ?? 'Sistema' }}</small></p>
                            @can('view', $occ)
                                <a href="{{ route('occurrences.show', $occ) }}" class="btn btn-outline-primary btn-sm">Ver</a>
                            @endcan
                            @can('update', $occ)
                                @if(Route::has('occurrences.edit'))
                                    <a href="{{ route('occurrences.edit', $occ) }}" class="btn btn-outline-secondary btn-sm">Editar</a>
                                @endif
                            @endcan
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="mt-3">{{ $occurrences->links() }}</div>
    @endif
</div>
@endsection

