@php
    $user = \Illuminate\Support\Facades\Auth::user();
    $layout = 'layouts.app';
    if ($user) {
        if ($user->role === 'client') $layout = 'layouts.client';
        elseif ($user->role === 'employee') $layout = 'layouts.employee';
        elseif ($user->role === 'superadmin') $layout = 'layouts.admin';
    }
@endphp

@extends($layout)

@section('content')
<div class="container">
    <div class="card">
        <div class="card-body">
            <h3>{{ $occurrence->title ?? ('Ocorrência #' . $occurrence->id) }}</h3>
            <p class="text-muted">Tipo: {{ $occurrence->type->name ?? '—' }} • Empresa: {{ $occurrence->company->name ?? '—' }}</p>
            <hr>
            <div>{!! nl2br(e($occurrence->details ?? '-')) !!}</div>
            @if($occurrence->attachments->count())
                <hr>
                <h6>Anexos</h6>
                <ul>
                    @foreach($occurrence->attachments as $att)
                        <li><a href="{{ route('attachments.download', $att->id) }}">{{ $att->original_name ?? $att->path }}</a></li>
                    @endforeach
                </ul>
            @endif
            <a href="{{ url()->previous() }}" class="btn btn-outline-secondary mt-3">Voltar</a>
        </div>
    </div>
</div>
@endsection
