@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Editar Ocorrência</h1>
    <form method="POST" action="{{ route('occurrences.update', $occurrence->id) }}">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label class="form-label">Título</label>
            <input type="text" name="title" class="form-control" value="{{ old('title', $occurrence->title) }}">
        </div>
        <div class="mb-3">
            <label class="form-label">Detalhes</label>
            <textarea name="details" class="form-control" rows="6">{{ old('details', $occurrence->details) }}</textarea>
        </div>
        <button class="btn btn-primary">Salvar</button>
        <a href="{{ route('occurrences.show', $occurrence->id) }}" class="btn btn-outline-secondary">Cancelar</a>
    </form>
</div>
@endsection
