<nav class="navbar navbar-expand-lg navbar-light bg-light">
  <div class="container-fluid">
    <a class="navbar-brand" href="{{ route('dashboard') }}">{{ config('app.name', 'Virtual Office') }}</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link" href="{{ route('dashboard') }}">Dashboard</a>
        </li>
        @auth
        <li class="nav-item">
          <a class="nav-link" href="{{ route('company.indexPanel') }}">Empresas</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{ route('attachments.index') }}">Anexos</a>
        </li>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="occTypesMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">Ocorrências</a>
          <ul class="dropdown-menu" aria-labelledby="occTypesMenu">
            <li><a class="dropdown-item" href="{{ route('occurrences.chamadas') }}">Chamadas</a></li>
            <li><a class="dropdown-item" href="{{ route('occurrences.emails') }}">Emails</a></li>
            <li><a class="dropdown-item" href="{{ route('occurrences.recepcao') }}">Recepção</a></li>
          </ul>
        </li>
        @if(in_array(Auth::user()->role, ['employee','superadmin']))
        <li class="nav-item">
          <a class="nav-link" href="{{ route('employee.companies') }}">Área Funcionário</a>
        </li>
        @endif
        @endauth
      </ul>

      <ul class="navbar-nav ms-auto">
        @auth
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="userMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            {{ Auth::user()->name }}
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userMenu">
            <li><a class="dropdown-item" href="{{ route('profile.edit') }}">Perfil</a></li>
            <li>
              <form method="POST" action="{{ route('logout') }}">@csrf
                <button class="dropdown-item" type="submit">Sair</button>
              </form>
            </li>
          </ul>
        </li>
    @else
    <li class="nav-item"><a class="nav-link" href="{{ route('login') }}">Login</a></li>
    @if (Route::has('register'))
      <li class="nav-item"><a class="nav-link" href="{{ route('register') }}">Registrar</a></li>
    @endif
    @endauth
      </ul>
    </div>
  </div>
</nav>
