<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'Virtual Office') }} - Admin</title>
    <link rel="apple-touch-icon" sizes="76x76" href="{{ asset('assets/img/apple-icon.png') }}">
    <link rel="icon" type="image/png" href="{{ asset('assets/img/favicon.png') }}">

    <!-- Fonts and icons -->
    <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700,900" />
    <link href="{{ asset('assets/css/nucleo-icons.css') }}" rel="stylesheet" />
    <link href="{{ asset('assets/css/nucleo-svg.css') }}" rel="stylesheet" />
    <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />

    <!-- CSS Files -->
    @php
        $cssPath = public_path('assets/css/material-dashboard.min.css');
        $cssVer = file_exists($cssPath) ? filemtime($cssPath) : time();
    @endphp
    <link id="pagestyle" href="{{ asset('assets/css/material-dashboard.min.css') }}?v={{ $cssVer }}" rel="stylesheet" />
    @stack('styles')
</head>

<body class="g-sidenav-show  bg-gray-100">
    <aside class="sidenav navbar navbar-vertical navbar-expand-xs border-radius-lg fixed-start ms-2  bg-white my-2" id="sidenav-main">
        <div class="sidenav-header">
            <i class="fas fa-times p-3 cursor-pointer text-dark opacity-5 position-absolute end-0 top-0 d-none d-xl-none"
                aria-hidden="true" id="iconSidenav"></i>
            <a class="navbar-brand m-0" href="#">
                <img src="{{ asset('assets/img/logo-ct-dark.png') }}" class="navbar-brand-img" width="90" height="356" alt="main_logo">
                
            </a>
        </div>
        <hr class="horizontal dark mt-0 mb-2">
        <div class="collapse navbar-collapse  w-auto " id="sidenav-collapse-main">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active bg-gradient-dark text-white' : 'text-dark' }}"
                        href="{{ route('admin.dashboard') }}">
                        <i class="material-symbols-rounded opacity-5">dashboard</i>
                        <span class="nav-link-text ms-1">Dashboard</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.users.index') ? 'active bg-gradient-dark text-white' : 'text-dark' }}" href="{{ route('admin.users.index') }}">
                        <i class="material-symbols-rounded opacity-5">supervisor_account</i>
                        <span class="nav-link-text ms-1">Funcionários</span>
                    </a>
                </li>
                <!-- Add more admin links as needed -->
            </ul>
        </div>
        <div class="sidenav-footer position-absolute w-100 bottom-0 ">
            <div class="mx-3">
                <form method="POST" action="{{ route('logout') }}">@csrf
                    <button class="btn btn-outline-dark mt-4 w-100" type="submit">Sair</button>
                </form>
            </div>
        </div>
    </aside>

    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <nav class="navbar navbar-main navbar-expand-lg px-0 mx-3 shadow-none border-radius-xl" id="navbarBlur" data-scroll="true">
            <div class="container-fluid py-1 px-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
                        <li class="breadcrumb-item text-sm"><a class="opacity-5 text-dark" href="javascript:;">Pages</a></li>
                        <li class="breadcrumb-item text-sm text-dark active" aria-current="page">Dashboard</li>
                    </ol>
                </nav>
                <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                    <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                        <div class="input-group input-group-outline">
                            <label class="form-label">Pesquisar...</label>
                            <input type="text" class="form-control">
                        </div>
                    </div>
                    <ul class="navbar-nav d-flex align-items-center  justify-content-end">
                        <li class="nav-item d-flex align-items-center">
                            <a class="nav-link text-body font-weight-bold px-0">
                                <i class="material-symbols-rounded">account_circle</i>
                                <span class="d-sm-inline d-none ms-1">{{ Auth::user()->name }}</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- End Navbar -->

        <div class="container-fluid py-2">
            @yield('content')
        </div>
    </main>

    <!--   Core JS Files   -->
    @php
        $jsBootstrap = public_path('assets/js/core/bootstrap.bundle.min.js');
        $jsBootstrapVer = file_exists($jsBootstrap) ? filemtime($jsBootstrap) : time();

        $jsChart = public_path('assets/js/plugins/chartjs.min.js');
        $jsChartVer = file_exists($jsChart) ? filemtime($jsChart) : time();

        $jsMat = public_path('assets/js/material-dashboard.min.js');
        $jsMatVer = file_exists($jsMat) ? filemtime($jsMat) : time();
    @endphp
    <script src="{{ asset('assets/js/core/bootstrap.bundle.min.js') }}?v={{ $jsBootstrapVer }}"></script>
    <script src="{{ asset('assets/js/plugins/perfect-scrollbar.min.js') }}?v={{ $jsMatVer }}"></script>
    <script src="{{ asset('assets/js/plugins/smooth-scrollbar.min.js') }}?v={{ $jsMatVer }}"></script>
    <script src="{{ asset('assets/js/plugins/chartjs.min.js') }}?v={{ $jsChartVer }}"></script>
    <script src="{{ asset('assets/js/material-dashboard.min.js') }}?v={{ $jsMatVer }}"></script>
    @stack('scripts')
    @include('partials.toasts')
</body>

</html>
