@extends('layouts.employee')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card my-4">
            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-dark shadow-dark border-radius-lg pt-4 pb-3">
                    <h6 class="text-white text-capitalize ps-3">{{ $occType->name ?? 'Ocorrências' }}</h6>
                </div>
            </div>
            <div class="card-body px-0 pb-2">
                <div class="p-3 d-flex justify-content-end">
                    {{-- When creating an occurrence as employee, show create for this company's type if company provided, else point to generic create route --}}
                    @if(isset($company))
                        <a href="{{ route('employee.companies.occurrences.create', $company->id) }}" class="btn btn-success">Criar Ocorrência</a>
                    @else
                        @php $slug = \Illuminate\Support\Str::ascii(\Illuminate\Support\Str::slug($occType->name, '')); @endphp
                        @if(in_array($slug, ['chamadas','emails','recepcao']))
                            <a href="{{ route('occurrences.' . $slug . '.create') }}" class="btn btn-success">Criar Ocorrência</a>
                        @else
                            <a href="{{ route('occurrences.chamadas.create') }}" class="btn btn-success">Criar Ocorrência</a>
                        @endif
                    @endif
                </div>
                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                            <tr>
                                <th>Título</th>
                                <th>Registro</th>
                                <th class="text-center">Empresa</th>
                                <th class="text-center">Anexos</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($occurrences as $occ)
                                <tr>
                                    <td>
                                        <div class="d-flex px-2 py-1">
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">{{ Str::limit($occ->title ?? $occ->description ?? '', 30) }}</h6>
                                                <p class="text-xs text-secondary mb-0">{{ Str::limit($occ->description, 80) }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="text-secondary text-xs">{{ $occ->created_at->format('d/m/Y H:i') }}</span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs">{{ $occ->company->name ?? '-' }}</span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs">{{ $occ->attachments->count() }}</span>
                                    </td>
                                    <td class="align-middle text-end">
                                        <a href="{{ route('occurrences.show', $occ->id) }}" class="btn btn-sm btn-primary">Ver</a>
                                        @can('update', $occ)
                                            <a href="{{ route('occurrences.edit', $occ->id) }}" class="btn btn-sm btn-secondary">Editar</a>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-secondary">Nenhuma ocorrência encontrada.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="p-3">{{ $occurrences->links() }}</div>
            </div>
        </div>
    </div>
</div>
@endsection
