@extends('layouts.app')

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card my-4">
      <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        @php
            $headerClass = 'bg-gradient-secondary';
            if ($occurrence->status === 'open') $headerClass = 'bg-gradient-success';
            if ($occurrence->status === 'closed') $headerClass = 'bg-gradient-dark';
        @endphp
        <div class="{{ $headerClass }} shadow-dark border-radius-lg pt-4 pb-3">
          <h6 class="text-white text-capitalize ps-3">Ocorrência #{{ $occurrence->id }} - <small class="text-white">{{ ucfirst($occurrence->status) }}</small></h6>
        </div>
      </div>
      <div class="card-body px-0 pb-2">
        <div class="p-3">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <h5 class="mb-1">{{ $occurrence->title ?? ($occurrence->type->name ?? 'Ocorrência') }}</h5>
              <p class="text-sm text-secondary mb-0">{{ $occurrence->type->name ?? '' }} • Registrada em {{ $occurrence->created_at->format('d/m/Y H:i') }} por {{ $occurrence->user->name ?? 'Sistema' }}</p>
            </div>
            <div class="text-end">
              <a href="{{ url()->previous() }}" class="btn btn-sm btn-outline-dark">Voltar</a>
              @can('update', $occurrence)
                <a href="{{ route('occurrences.edit', $occurrence->id) }}" class="btn btn-sm btn-secondary">Editar</a>
              @endcan
            </div>
          </div>

          <hr class="my-3">

          @php
            $details = trim($occurrence->details ?? '');
            $isLong = strlen(strip_tags($details)) > 400;
          @endphp
          <div class="mb-2">
            <div class="alert alert-light alert-dismissible text-dark p-3" role="alert">
              <div class="text-sm" id="occurrence-content">
                @if($isLong)
                  <div id="occ-preview">{!! nl2br(e(Str::limit($details, 400))) !!}</div>
                  <div id="occ-full" style="display:none">{!! nl2br(e($details)) !!}</div>
                  <a href="#" id="toggle-occ" class="small">Mostrar mais</a>
                @else
                  {!! nl2br(e($details)) !!}
                @endif
              </div>
            </div>
          </div>

          @if($occurrence->attachments->count())
            <hr>
            <h6>Anexos</h6>
            <ul>
              @foreach($occurrence->attachments as $att)
                <li><a href="{{ route('attachments.download', $att->id) }}">{{ $att->original_name ?? $att->path }}</a></li>
              @endforeach
            </ul>
          @endif
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.8.0/highlight.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.8.0/styles/default.min.css">
<script>
document.addEventListener('DOMContentLoaded', function(){
  var toggle = document.getElementById('toggle-occ');
  if (toggle) {
    toggle.addEventListener('click', function(e){
      e.preventDefault();
      var full = document.getElementById('occ-full');
      var preview = document.getElementById('occ-preview');
      if (full.style.display === 'none') {
        full.style.display = 'block'; preview.style.display = 'none'; toggle.textContent = 'Mostrar menos';
        // run highlight if code blocks exist
        if (window.hljs) { document.querySelectorAll('#occurrence-content pre code').forEach((el)=>hljs.highlightElement(el)); }
      } else {
        full.style.display = 'none'; preview.style.display = 'block'; toggle.textContent = 'Mostrar mais';
      }
    });
  }
});
</script>
@endpush
