@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-12">
            <h1>Painel: {{ $company->name }}</h1>
            <div class="list-group">
                @foreach($occurrences as $occ)
                    <div class="list-group-item">
                        <div class="d-flex w-100 justify-content-between">
                            <h5 class="mb-1">{{ $occ->type->name }}</h5>
                            <small>{{ $occ->created_at->format('Y-m-d H:i') }}</small>
                        </div>
                        <p class="mb-1">{{ $occ->details }}</p>
                        <small>Funcionário: {{ $occ->user->name ?? '—' }}</small>
                        @if($occ->attachments->count())
                            <div class="mt-2">
                                <strong>Anexos:</strong>
                                <ul>
                                    @foreach($occ->attachments as $att)
                                        <li><a href="{{ route('attachments.download', $att->id) }}">{{ $att->original_name }}</a></li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection
