@php
    $user = \Illuminate\Support\Facades\Auth::user();
    $layout = 'layouts.app';
    if ($user) {
        if ($user->role === 'client') $layout = 'layouts.client';
        elseif ($user->role === 'employee') $layout = 'layouts.employee';
        elseif ($user->role === 'superadmin') $layout = 'layouts.admin';
    }
@endphp

@extends($layout)

@section('header')
<h2>Ocorrências: {{ $occType->name }} — {{ $company->name }}</h2>
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        <table class="table table-sm">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Detalhes</th>
                    <th>Origem</th>
                    <th>Anexos</th>
                    <th>Data</th>
                </tr>
            </thead>
            <tbody>
                @forelse($occurrences as $occ)
                <tr>
                    <td>{{ $occ->id }}</td>
                    <td>{{ \\Illuminate\Support\Str::limit($occ->details, 100) }}</td>
                    <td>{{ optional($occ->user)->name ?? 'Sistema' }}</td>
                    <td>{{ $occ->attachments->count() }}</td>
                    <td>{{ $occ->created_at->format('Y-m-d H:i') }}</td>
                </tr>
                @empty
                <tr><td colspan="5">Nenhuma ocorrência encontrada.</td></tr>
                @endforelse
            </tbody>
        </table>

        {{ $occurrences->links() }}
    </div>
</div>
@endsection
