@extends('layouts.admin')

@section('content')
    <div class="row">
        <div class="col-12">
            <h1>Empresas</h1>
            @if(Auth::user() && in_array(Auth::user()->role, ['employee','superadmin']))
                <div class="mb-3 text-end">
                    <a href="{{ route('companies.create') }}" class="btn btn-primary">Cadastrar empresa</a>
                </div>
            @endif
            <ul class="list-group">
                @foreach($companies as $c)
                    <li class="list-group-item"><a href="{{ route('company.panel', $c->id) }}">{{ $c->name }}</a></li>
                @endforeach
            </ul>
        </div>
    </div>
@endsection