@extends('layouts.client')

@section('content')
<div class="container">
    <h1>Attachments</h1>
    <p>Company: {{ $company->name ?? '' }}</p>

    @if($attachments->count())
        <ul>
            @foreach($attachments as $att)
                <li><a href="{{ route('attachments.download', $att->id) }}">{{ $att->filename ?? 'file' }}</a> - {{ $att->created_at->format('d/m/Y') }}</li>
            @endforeach
        </ul>
        {{ $attachments->links() }}
    @else
        <p>No attachments found.</p>
    @endif
</div>
@endsection
