@extends('layouts.app')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">Registrar</div>

            <div class="card-body">
                <form method="POST" action="{{ route('register') }}">
                    @csrf

                    <div class="mb-3">
                        <label for="name" class="form-label">Nome</label>
                        <input id="name" name="name" value="{{ old('name') }}" required autofocus class="form-control">
                        @error('name')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input id="email" name="email" type="email" value="{{ old('email') }}" required class="form-control">
                        @error('email')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="mb-3">
                        <label for="password" class="form-label">Password</label>
                        <input id="password" name="password" type="password" required class="form-control">
                        @error('password')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">Confirmar Password</label>
                        <input id="password_confirmation" name="password_confirmation" type="password" required class="form-control">
                    </div>

                    <div class="mb-3">
                        <label for="company_name" class="form-label">Nome da Empresa</label>
                        <input id="company_name" name="company_name" type="text" value="{{ old('company_name') }}" required class="form-control">
                        @error('company_name')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="mb-3">
                        <label for="company_identifier" class="form-label">Identificador (opcional)</label>
                        <input id="company_identifier" name="company_identifier" type="text" value="{{ old('company_identifier') }}" class="form-control">
                        @error('company_identifier')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="d-flex justify-content-between align-items-center">
                        <a href="{{ route('login') }}">Já tem conta?</a>
                        <button class="btn btn-primary" type="submit">Registrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
