@extends('layouts.admin')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6 col-md-8 col-12">
        <div class="card z-index-0">
            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-dark shadow-dark border-radius-lg py-3 pe-1">
                    <h4 class="text-white font-weight-bolder text-center mt-2 mb-0">Editar Funcionário</h4>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.users.update', $user->id) }}" method="POST">
                    @csrf
                    @method('PATCH')

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Nome</label>
                        <input id="name" name="name" class="form-control" required value="{{ old('name', $user->name) }}">
                        @error('name')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Email</label>
                        <input id="email" name="email" type="email" class="form-control" required value="{{ old('email', $user->email) }}">
                        @error('email')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Senha (deixe em branco para manter)</label>
                        <input id="password" name="password" type="password" class="form-control">
                        @error('password')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Confirmar senha</label>
                        <input id="password_confirmation" name="password_confirmation" type="password" class="form-control">
                    </div>

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Função</label>
                        <select name="role" class="form-control">
                            <option value="employee" {{ old('role', $user->role)=='employee' ? 'selected' : '' }}>Funcionário</option>
                            <option value="superadmin" {{ old('role', $user->role)=='superadmin' ? 'selected' : '' }}>Superadmin</option>
                        </select>
                        @error('role')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="text-end">
                        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary me-2">Cancelar</a>
                        <button class="btn bg-gradient-dark" type="submit">Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
