@extends('layouts.admin')

@section('content')
<div class="row">
    <div class="ms-3">
        <h3 class="mb-0 h4 font-weight-bolder">Painel do Administrador</h3>
        <p class="mb-4">Visão geral do sistema.</p>
    </div>

    <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
        <div class="card">
            <div class="card-header p-2 ps-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <p class="text-sm mb-0 text-capitalize">Empresas</p>
                        <h4 class="mb-0">{{ $companiesCount ?? 0 }}</h4>
                    </div>
                    <div class="icon icon-md icon-shape bg-gradient-dark shadow-dark shadow text-center border-radius-lg">
                        <i class="material-symbols-rounded opacity-10">business</i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
        <div class="card">
            <div class="card-header p-2 ps-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <p class="text-sm mb-0 text-capitalize">Empresas Activas</p>
                        <h4 class="mb-0">{{ $activeCompanies ?? 0 }}</h4>
                    </div>
                    <div class="icon icon-md icon-shape bg-gradient-dark shadow-dark shadow text-center border-radius-lg">
                        <i class="material-symbols-rounded opacity-10">business_center</i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
        <div class="card">
            <div class="card-header p-2 ps-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <p class="text-sm mb-0 text-capitalize">Funcionários</p>
                        <h4 class="mb-0">{{ $employeesCount ?? 0 }}</h4>
                    </div>
                    <div class="icon icon-md icon-shape bg-gradient-dark shadow-dark shadow text-center border-radius-lg">
                        <i class="material-symbols-rounded opacity-10">supervisor_account</i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-sm-6">
        <div class="card">
            <div class="card-header p-2 ps-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <p class="text-sm mb-0 text-capitalize">Ocorrências</p>
                        <h4 class="mb-0">{{ $occurrencesCount ?? 0 }}</h4>
                    </div>
                    <div class="icon icon-md icon-shape bg-gradient-dark shadow-dark shadow text-center border-radius-lg">
                        <i class="material-symbols-rounded opacity-10">assignment</i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-lg-4 col-md-6 mt-4 mb-4">
        <div class="card">
            <div class="card-body">
                <h6 class="mb-0 ">Empresas (últimos 30 dias)</h6>
                <p class="text-sm ">Evolução por dia</p>
                <div class="pe-2">
                    <div class="chart">
                        <canvas id="companiesChart" class="chart-canvas" height="170"></canvas>
                    </div>
                </div>
                <hr class="dark horizontal">
                <div class="d-flex ">
                    <i class="material-symbols-rounded text-sm my-auto me-1">schedule</i>
                    <p class="mb-0 text-sm">Dados dos últimos 30 dias</p>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4 col-md-6 mt-4 mb-4">
        <div class="card ">
            <div class="card-body">
                <h6 class="mb-0 ">Chamadas (últimos 30 dias)</h6>
                <p class="text-sm ">Evolução por dia</p>
                <div class="pe-2">
                    <div class="chart">
                        <canvas id="chart-bars" class="chart-canvas" height="170"></canvas>
                    </div>
                </div>
                <hr class="dark horizontal">
                <div class="d-flex ">
                    <i class="material-symbols-rounded text-sm my-auto me-1">schedule</i>
                    <p class="mb-0 text-sm">Dados dos últimos 30 dias</p>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4 mt-4 mb-3">
        <div class="card">
            <div class="card-body">
                <h6 class="mb-0 ">Emails (últimos 30 dias)</h6>
                <p class="text-sm ">Evolução por dia</p>
                <div class="pe-2">
                    <div class="chart">
                        <canvas id="chart-line" class="chart-canvas" height="170"></canvas>
                    </div>
                </div>
                <hr class="dark horizontal">
                <div class="d-flex ">
                    <i class="material-symbols-rounded text-sm my-auto me-1">schedule</i>
                    <p class="mb-0 text-sm">Dados dos últimos 30 dias</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script id="chart-data-companies" type="application/json">@json($chartCompanies ?? ['labels'=>[], 'data'=>[]])</script>
<script id="chart-data-calls" type="application/json">@json($chartCalls ?? ['labels'=>[], 'data'=>[]])</script>
<script id="chart-data-emails" type="application/json">@json($chartEmails ?? ['labels'=>[], 'data'=>[]])</script>
<script>
    var chartCompanies = JSON.parse(document.getElementById('chart-data-companies').textContent || '{}');
    var chartCalls = JSON.parse(document.getElementById('chart-data-calls').textContent || '{}');
    var chartEmails = JSON.parse(document.getElementById('chart-data-emails').textContent || '{}');

    document.addEventListener('DOMContentLoaded', function() {
        // Companies - line chart (styled like employee email chart)
        var ctxC = document.getElementById('companiesChart').getContext('2d');
        if (ctxC && window.Chart) {
            new Chart(ctxC, {
                type: 'line',
                data: {
                    labels: chartCompanies.labels || [],
                    datasets: [{
                        label: 'Empresas',
                        tension: 0,
                        borderWidth: 2,
                        pointRadius: 3,
                        pointBackgroundColor: '#43A047',
                        pointBorderColor: 'transparent',
                        borderColor: '#43A047',
                        backgroundColor: 'transparent',
                        fill: true,
                        data: chartCompanies.data || [],
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: { legend: { display: false } },
                    interaction: { intersect: false, mode: 'index' },
                    scales: {
                        y: { grid: { drawBorder: false, display: true, drawOnChartArea: true, drawTicks: false, borderDash: [4,4], color: '#e5e5e5' }, ticks: { display: true, color: '#737373', padding: 10, font: { size: 12, lineHeight: 2 } } },
                        x: { grid: { display: false }, ticks: { display: true, color: '#737373', padding: 10, font: { size: 12, lineHeight: 2 } } }
                    }
                }
            });
        }

        // Calls - bar chart (same as employee chart-bars)
        var elCalls = document.getElementById('chart-bars');
        if (elCalls && window.Chart) {
            var ctx = elCalls.getContext('2d');
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: chartCalls.labels || [],
                    datasets: [{
                        label: 'Calls',
                        tension: 0.4,
                        borderWidth: 0,
                        borderRadius: 4,
                        borderSkipped: false,
                        backgroundColor: '#43A047',
                        data: chartCalls.data || [],
                        barThickness: 'flex'
                    }],
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: { legend: { display: false } },
                    interaction: { intersect: false, mode: 'index' },
                    scales: {
                        y: { grid: { drawBorder: false, display: true, drawOnChartArea: true, drawTicks: false, borderDash: [5,5], color: '#e5e5e5' }, ticks: { suggestedMin: 0, suggestedMax: 500, beginAtZero: true, padding: 10, font: { size: 14, lineHeight: 2 }, color: '#737373' } },
                        x: { grid: { display: false }, ticks: { display: true, color: '#737373', padding: 10, font: { size: 14, lineHeight: 2 } } }
                    }
                }
            });
        }

        // Emails - line chart (same as employee chart-line)
        var elEmails = document.getElementById('chart-line');
        if (elEmails && window.Chart) {
            var ctx2 = elEmails.getContext('2d');
            new Chart(ctx2, {
                type: 'line',
                data: {
                    labels: chartEmails.labels || [],
                    datasets: [{
                        label: 'Emails',
                        tension: 0,
                        borderWidth: 2,
                        pointRadius: 3,
                        pointBackgroundColor: '#43A047',
                        pointBorderColor: 'transparent',
                        borderColor: '#43A047',
                        backgroundColor: 'transparent',
                        fill: true,
                        data: chartEmails.data || [],
                        maxBarThickness: 6
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: { legend: { display: false }, tooltip: { callbacks: { title: function(context){ return context[0] ? context[0].label : ''; } } } },
                    interaction: { intersect: false, mode: 'index' },
                    scales: {
                        y: { grid: { drawBorder: false, display: true, drawOnChartArea: true, drawTicks: false, borderDash: [4,4], color: '#e5e5e5' }, ticks: { display: true, color: '#737373', padding: 10, font: { size: 12, lineHeight: 2 } } },
                        x: { grid: { display: false }, ticks: { display: true, color: '#737373', padding: 10, font: { size: 12, lineHeight: 2 } } }
                    }
                }
            });
        }
    });
</script>
@endpush
