<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        \App\Models\User::updateOrCreate(
            ['email' => 'admin@virtual.com'],
            [
                'name' => 'Superadmin',
                'password' => bcrypt('admin123'),
                'role' => 'superadmin',
            ]
        );

        // Create a sample company, occurrence type, occurrence and attachment for testing
        $company = \App\Models\Company::firstOrCreate([
            'name' => 'ACME'
        ], [
            'identifier' => '0001',
            'created_by' => \App\Models\User::where('email', 'admin@virtual.com')->first()->id ?? null,
        ]);

        $type = \App\Models\OccurrenceType::firstOrCreate(['name' => 'Call']);

        $occurrence = \App\Models\Occurrence::create([
            'company_id' => $company->id,
            'occurrence_type_id' => $type->id,
            'user_id' => \App\Models\User::where('email', 'admin@virtual.com')->first()->id ?? null,
            'details' => 'Seeded test occurrence',
            'status' => 'open',
        ]);

        // ensure attachments folder exists
        $attachmentsPath = storage_path('app/public/attachments');
        if (! is_dir($attachmentsPath)) {
            mkdir($attachmentsPath, 0755, true);
        }

        $sampleFile = $attachmentsPath . DIRECTORY_SEPARATOR . 'sample.txt';
        if (! file_exists($sampleFile)) {
            file_put_contents($sampleFile, "Sample attachment for occurrence #{$occurrence->id}\n");
        }

        \App\Models\Attachment::firstOrCreate([
            'occurrence_id' => $occurrence->id,
            'path' => 'attachments/sample.txt',
        ], [
            'original_name' => 'sample.txt',
        ]);
    }
}
