<?php

namespace App\Http\Controllers;

use App\Models\OccurrenceType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class OccurrenceTypeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        return OccurrenceType::all();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        $type = OccurrenceType::create($data);
        return response()->json($type, 201);
    }
}